/* exported mc_rapid_correct */
/* exported mc_repair_cnt_correct */
/* exported mc_get_rapid_correct */
/* exported mc_bright_color_correct */
/* exported mc_get_hw_gamut */
/* exported mc_handle_screen_box_corr */


/* global $ */
/* global mc_sdk_param */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送/固化 (快速校正/色域控制)
 * 参数:
 *    @param {Promise<String>} str_order 命令
 *    @param {Promise<String>} str_mode 开启色域
 *    @param {Promise<String>} arr_lsit 校正使用数据 若str_mode = 0 则不设此值
 *    @param {Promise<String>} str_chip_name 接收卡芯片名称(可选)
 *    @param {Promise<String>} str_memtype 读发 RAM 固化FLASH
 *    @param {Promise<Function>} fun_callback 回调
 * 返回：
 *   @returns {Promise<String>} str_error_date 错误码
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.10
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_rapid_correct(str_order, str_mode, arr_lsit, str_chip_name, str_memtype, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var str_workmode = "0";

    if ("RAM" === str_memtype) {
        if (parent.b_if_mass) {
            str_workmode = "1";
        }
    }
    if ("FLASH" === str_memtype) {
        if (parent.b_if_mass) {
            str_workmode = "1";
        }
        if (parent.b_if_mirror) {
            str_workmode = "2";
        }
        if (parent.b_if_mass && parent.b_if_mirror) {
            str_workmode = "3";
        }
    }
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_BOX_GAMUT");
    obj_req.set_param_value("RECVCARD", str_order);
    var str_list;

    if (str_mode) {
        str_list = mc_parse_tab(arr_lsit);
        obj_req.set_attr_val("RECVCARD", "MODE", "1");
        obj_req.set_attr_val("RECVCARD", "LIST", str_list);
    } else {
        obj_req.set_attr_val("RECVCARD", "MODE", "0");
    }

    obj_req.set_attr_val("RECVCARD", "CHIPNAME", str_chip_name);
    obj_req.set_attr_val("RECVCARD", "MEMTYPE", str_memtype);
    // obj_req.set_attr_val("RECVCARD", "WORKMODE", str_workmode);
    parent.g_str_test_data = obj_req.get_json();

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }

        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");

        fun_callback(str_error_date);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取 (快速校正/色域控制)
 * 参数:
 *    @param {Promise<String>} str_order 命令
 *    @param {Promise<String>} str_mode 校正使用数据
 *    @param {Promise<String>} str_ctrl_card 主控芯片

 *    @param {Promise<Function>} fun_callback 回调
 * 返回：
 *   @returns {Promise<String>} str_error_date 错误码
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.10
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_rapid_correct(str_order, str_mode, str_ctrl_card, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_BOX_GAMUT");
    obj_req.set_param_value("RECVCARD", str_order);
    if (str_mode) {
        obj_req.set_attr_val("RECVCARD", "MODE", "1");
    } else {
        obj_req.set_attr_val("RECVCARD", "MODE", "0");
    }
    if (!str_ctrl_card) {
        str_ctrl_card = "T6";
    }
    obj_req.set_attr_val("RECVCARD", "CHIPNAME", str_ctrl_card);

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }

        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");
        var str_mode_val = obj_res.get_attr_val("RECVCARD", "MODE");
        var str_list = obj_res.get_attr_val("RECVCARD", "LIST");
        var str_chip = obj_res.get_attr_val("RECVCARD", "CHIPNAME");
        // var str_hw_data = obj_res.get_attr_val("RECVCARD", "DATA");

        var obj_data = {
            err: str_error_date,
            mode: str_mode_val,
            list: str_list,
            chip: str_chip
            // hw_data: str_hw_data
        };

        fun_callback(obj_data);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置或读取 (逐点校正)
 * 参数:
 *    @param {Promise<String>}  str_cmd 硬件读写操作
 *    @param {Promise<String>} str_order 命令
 *    @param {Promise<String>} str_mode 开启色域 0 不矫正 1 亮度校正 2 色度校正
 *    @param {Promise<String>} str_list 校正使用数据 若str_mode = 0 则不设此值
 *    @param {Promise<String>} str_chip_name 接收卡芯片名称(可选)
 *    @param {Promise<String>} str_memtype 读发 RAM 固化FLASH
 *    @param {Promise<Function>} fun_callback 回调
 * 返回：
 *   @returns {Promise<String>} str_error_date 错误码
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.10
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_bright_color_correct(str_cmd, str_order, str_mode, str_list, str_chip_name, str_memtype, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }


    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd(str_cmd);
    obj_req.set_func("HW_BOX_RECTIFY");
    obj_req.set_param_value("0", str_order);
    obj_req.set_attr_val("0", "MODE", str_mode);
    if (0 !== Number(str_mode)) {
        // 解析原数据文件
        var str_list_data = "";

        // 大屏进来不需解析 由外部解析
        if (str_from_page) {
            str_list_data = str_list;
        } else {
            str_list_data = mc_parsing_data(str_list);
        }

        // 处理下发的数据参数
        str_list_data = mc_handle_date_coor(str_list_data);

        obj_req.set_attr_val("0", "LIST", str_list_data);
        // if (str_list_data) {
        //     obj_req.set_attr_val("0", "LIST", str_list_data);
        // } else {
        //     fun_callback(false);
        //     return;
        // }
    }

    if (str_chip_name) {
        obj_req.set_attr_val("0", "CHIPNAME", str_chip_name);
    }
    obj_req.set_attr_val("0", "MEMTYPE", str_memtype);

    if ("SET_PARAM" === str_cmd) {
        var str_workmode = "0";

        if ("RAM" === str_memtype) {
            if (parent.b_if_mass) {
                str_workmode = "1";
            }
        }
        if ("FLASH" === str_memtype) {
            if (parent.b_if_mass) {
                str_workmode = "1";
            }
            if (parent.b_if_mirror) {
                str_workmode = "2";
            }
            if (parent.b_if_mass && parent.b_if_mirror) {
                str_workmode = "3";
            }
        }
        // obj_req.set_attr_val("0", "WORKMODE", str_workmode);
    }


    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        // if ("success" !== status) {
        //     fun_callback("");
        //     return;
        // }

        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");

        fun_callback(str_error_date);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置或读取 (修缝数)
 * 参数:
 *    @param {Promise<String>}  str_cmd 硬件读写操作
 *    @param {Promise<String>} str_order 命令
 *    @param {Promise<String>} str_mode 启用修缝 0 不启用 其他启用
 *    @param {Promise<String>} str_list 校正使用数据 若str_mode = 0 则不设此值
 *    @param {Promise<String>} str_chip_name 接收卡芯片名称(可选)
 *    @param {Promise<String>} str_memtype 读发 RAM 固化FLASH
 *    @param {Promise<Function>} fun_callback 回调
 * 返回：
 *   @returns {Promise<String>} str_error_date 错误码
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.27
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_repair_cnt_correct(str_cmd, str_order, str_mode, str_list, str_chip_name, str_memtype, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd(str_cmd);
    obj_req.set_func("HW_BOX_ANTIGAP");
    obj_req.set_param_value("RECVCARD", str_order);
    obj_req.set_attr_val("RECVCARD", "MODE", str_mode);
    if (0 !== Number(str_mode)) {
        var str_list_data = "";

        // 大屏进来不需解析 由外部解析
        if (str_from_page) {
            str_list_data = str_list;
        } else {
            str_list_data = mc_parsing_data(str_list);
        }


        // 处理下发的数据参数
        str_list_data = mc_handle_date_coor(str_list_data);

        obj_req.set_attr_val("RECVCARD", "LIST", str_list_data);
        // if (str_list_data) {
        //     obj_req.set_attr_val("RECVCARD", "LIST", str_list_data);
        // } else {
        //     fun_callback(false);
        //     return;
        // }
    }

    obj_req.set_attr_val("RECVCARD", "CHIPNAME", str_chip_name);
    obj_req.set_attr_val("RECVCARD", "MEMTYPE", str_memtype);
    if ("SET_PARAM" === str_cmd) {
        var str_workmode = "0";

        if ("RAM" === str_memtype) {
            if (parent.b_if_mass) {
                str_workmode = "1";
            }
        }
        if ("FLASH" === str_memtype) {
            if (parent.b_if_mass) {
                str_workmode = "1";
            }
            if (parent.b_if_mirror) {
                str_workmode = "2";
            }
            if (parent.b_if_mass && parent.b_if_mirror) {
                str_workmode = "3";
            }
        }
        // obj_req.set_attr_val("RECVCARD", "WORKMODE", str_workmode);
    }


    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        // if ("success" !== status) {
        //     fun_callback("");
        //     return;
        // }

        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");

        fun_callback(str_error_date);
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析读取回来的颜色文件内容
 * 参数:
 *    @param {Promise<String>}  str 十六进制已转换原始的数据

 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_parsing_data(str) {
    if (!str) {
        return "";
    }
    var ary_all_line = str.split("\r\n");

    var ary_exp_ary = [];

    for (var idx_line = 0; idx_line <= ary_all_line.length; idx_line++) {
        if (!(ary_all_line[idx_line]) || 0 === ary_all_line[idx_line].length) {
            continue;
        }

        var ary_line_data = ary_all_line[idx_line].split(/[,]/);

        if (11 > ary_line_data.length) {
            continue;
        }

        var str_exp_sec = "(" + ary_line_data[0] + ":" + ary_line_data[1] + ":" +
            ary_line_data[2] + ":" + ary_line_data[5] + ":" + ary_line_data[8] + ":" +
            ary_line_data[3] + ":" + ary_line_data[6] + ":" + ary_line_data[9] + ":" +
            ary_line_data[4] + ":" + ary_line_data[7] + ":" + ary_line_data[10] + "),";

        ary_exp_ary.push(str_exp_sec);
    }

    var str_req_exp = ary_exp_ary.join("");

    str_req_exp = str_req_exp.slice(0, -1);
    return str_req_exp;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析读取表格的颜色数据
 * 参数:
 *    @param {Promise<Array>}  arr 表格数据

 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_parse_tab(arr) {
    var str_data;

    str_data = "(" + arr[0] + ":" + arr[4] + ":" + arr[7] + ":" + arr[1] + ":" + arr[3] + ":" + arr[8] + ":" + arr[2] + ":" + arr[5] + ":" + arr[6] + ")";

    return str_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *  根据坐标宽高获取文件所有坐标大小
 * 参数:
 *    @param {Promise<string>}  obj_info 当前大屏所设置的箱体(硬件位置/当前偏移位置)
 *    @param {Promise<string>}  str_file 文件数据
 *  备:
 *      文件用于获取对应箱体偏移位置的数据,没有则用默认值 (CRR,CGG,CBB):1 其余0
 *      关键是要有设置箱体
 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.11.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_screen_box_corr(obj_info, str_file) {
    // var arr_offset = Object.keys(obj_box_offset);

    // if (0 === arr_offset.length) {
    //     return false;
    // }

    // 不使用hub 则只显示 s-p-r 对比获取数据
    // if (!parent.b_corr_use_hub) {
    //     var arr_get_order = str_order.split(":");

    //     str_order = arr_get_order[0] + ":" + arr_get_order[1] + ":" + arr_get_order[4];
    // }

    // var str_order_key = "";
    // var arr_order = str_order.split(":");

    // str_order_key = arr_order[0] + ":" + arr_order[1] + ":" + arr_order[2] + ":" + arr_order[3];
    // var ui_rece = Number(arr_order[4]);
    // var str_temp_rece = str_order;

    // if (!arr_offset.includes(str_order)) {
    //     return false;
    // }

    // var obj_info = obj_box_offset[str_order];
    // var obj_info = arr_rece_offset[ui_rece];

    // if (!obj_info) {
    //     return false;
    // }

    var ui_box_x = obj_info.X;
    var ui_box_y = obj_info.Y;
    var ui_box_w = obj_info.W;
    var ui_box_h = obj_info.H;

    var ui_start_x = ui_box_x + 1;
    var ui_start_y = ui_box_y + 1;
    // var ui_end_x = ui_box_x + ui_box_w;
    // var ui_end_y = ui_box_y + ui_box_h;
    var obj_all = {};


    for (var id_x = 0; id_x < ui_box_w; id_x++) {
        for (var id_y = 0; id_y < ui_box_h; id_y++) {
            var str_coor = (ui_start_x + id_x) + ":" + (ui_start_y + id_y);

            obj_all[str_coor] = "";
        }
    }

    var str_return = "";


    if (str_file) {
        str_return = mc_get_file(obj_all, str_file);
    } else {
        str_return = mc_get_default(obj_all);
    }

    return str_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *  获取文件里有的数据 / 没有则用默认
 * 参数:
 *    @param {Promise<object>}  obj_all 当前下发的指令(坐标)
 *    @param {Promise<string>}  str_file 文件数据
 *  备:
 *      文件用于获取对应箱体偏移位置的数据,没有则用默认值 (CRR,CGG,CBB):1 其余0
 *      关键是要有设置箱体
 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.11.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_file(obj_all, str_file) {
    if (!str_file) {
        return "";
    }
    // 文件坐标数据
    var ary_all_line = str_file.split("\r\n");
    var ui_all_line_cnt = ary_all_line.length;
    // 当前下发的箱体坐标数据
    var arr_box_coor_keys = Object.keys(obj_all);
    var ui_box_line_cnt = arr_box_coor_keys.length;

    var ary_exp_ary = new Array(ui_box_line_cnt);

    // 文件数据
    var arr_file_all_coor = new Array(ui_all_line_cnt);
    var arr_file_all_data = new Array(ui_all_line_cnt);

    // 筛选出当前文件所有坐标位置
    for (var idx_line = 0; idx_line <= ui_all_line_cnt; idx_line++) {
        if (!(ary_all_line[idx_line]) || 0 === ary_all_line[idx_line].length) {
            continue;
        }

        var ary_line_data = ary_all_line[idx_line].trim().split(/[,]/);

        if (11 > ary_line_data.length) {
            continue;
        }
        var str_exp_sec = "(" + ary_line_data[0] + ":" + ary_line_data[1] + ":" +
            ary_line_data[2] + ":" + ary_line_data[5] + ":" + ary_line_data[8] + ":" +
            ary_line_data[3] + ":" + ary_line_data[6] + ":" + ary_line_data[9] + ":" +
            ary_line_data[4] + ":" + ary_line_data[7] + ":" + ary_line_data[10] + "),";

        arr_file_all_coor[idx_line] = ary_line_data[0] + ":" + ary_line_data[1];
        arr_file_all_data[idx_line] = str_exp_sec;
    }

    // 根据箱体点坐标获取文件坐标
    for (var idx = 0; idx < ui_box_line_cnt; idx++) {
        var str_box_coor = arr_box_coor_keys[idx];

        if (arr_file_all_coor.includes(str_box_coor)) {
            var idx_coor = mc_get_idx(arr_file_all_coor, str_box_coor);

            if (false === idx_coor) {
                ary_exp_ary[idx] = "(" + str_box_coor + ":1:0:0:0:1:0:0:0:1),";
                continue;
            }
            ary_exp_ary[idx] = arr_file_all_data[idx_coor];
        } else {
            ary_exp_ary[idx] = "(" + str_box_coor + ":1:0:0:0:1:0:0:0:1),";
        }
    }

    function mc_get_idx(ary, target) {
        var i = ary.length;

        while (i--) {
            if (ary[i] === target) {
                return i;
            }
            if (0 >= i) {
                return false;
            }
        }
        return false;
    }


    var str_req_exp = ary_exp_ary.join("");

    str_req_exp = str_req_exp.slice(0, -1);
    return str_req_exp;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *  没有文件用默认
 * 参数:
 *    @param {Promise<object>}  obj_all 当前下发的指令(坐标)
 *  备:
 *      文件用于获取对应箱体偏移位置的数据,没有则用默认值 (CRR,CGG,CBB):1 其余0
 *      关键是要有设置箱体
 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.11.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_default(obj_all) {
    var arr_box_coor_keys = Object.keys(obj_all);
    var ui_all_line_cnt = arr_box_coor_keys.length;
    var ary_exp_ary = new Array(ui_all_line_cnt);

    for (var idx = 0; idx < ui_all_line_cnt; idx++) {
        ary_exp_ary[idx] = "(" + arr_box_coor_keys[idx] + ":1:0:0:0:1:0:0:0:1),";
    }
    var str_req_exp = ary_exp_ary.join("");

    str_req_exp = str_req_exp.slice(0, -1);
    return str_req_exp;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *  处理下发数据
 * 参数:
 *    @param {Promise<string>}  str_date 当前下发的数据(坐标)
 *  备:
 *      因为处理的数据都以1,1开始 因此需都减1
 * 返回：
 *   @returns {Promise<string>} str_return  坐标都减1后的数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.11.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_date_coor(str_date) {
    var str_return = "";

    if (!str_date) {
        return str_return;
    }
    var arr_date = str_date.split(",");
    var ui_len = arr_date.length;


    for (var idx = 0; idx < ui_len; idx++) {
        var each_date = arr_date[idx].slice(1, -1);
        var arr_each_date = each_date.split(":");
        var str_new = "(";
        var str_x = Number(arr_each_date[0]) - 1;
        var str_y = Number(arr_each_date[1]) - 1;

        str_new += (str_x + ":" + str_y + ":" + arr_each_date[2] + ":" + arr_each_date[3] + ":" + arr_each_date[4] + ":" + arr_each_date[5] + ":" + arr_each_date[6] + ":" + arr_each_date[7] + ":" + arr_each_date[8] + ":" + arr_each_date[9] + ":" + arr_each_date[10]);
        str_new += "),";
        str_return += str_new;
    }
    str_return = str_return.slice(0, -1);
    return str_return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *      下发整屏所有箱体的数据
 * 参数:
 *    @param {Promise<string>}  val 当前下发的数据(坐标)
 *    @param {Promise<Array>}  arr_corr_offset 界面偏移(坐标)
 *    @param {Promise<string>}  str_spot_final_data 文件数据(坐标)
 *    @param {Promise<string>}  str_mode 开启色域
 *    @param {Promise<string>}  fun_callback 回调
 *  备:
 *
 * 返回：
 *   @returns {Promise<string>} str_return  坐标都减1后的数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.11.9
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_screen_data(val, arr_corr_offset, str_spot_final_data, str_mode, fun_callback) {
    var str_type = "RAM";
    var str_chip = "MINI";

    if ("load" === val) {
        str_type = "FLASH";
    }

    var ui_cnt = arr_corr_offset.length;
    var ui_idx = 0;
    var str_order = arr_corr_offset[ui_idx][0];

    mc_send();
    return;
    function mc_send() {
        if (ui_idx < ui_cnt) {
            var obj_size = arr_corr_offset[ui_idx][1];

            str_order = arr_corr_offset[ui_idx][0];
            var arr_order = str_order.split(":");
            var str_text_id = " ( ";

            if (3 === arr_order.length) {
                str_order = arr_order[0] + ":" + arr_order[1] + ":0:0:" + arr_order[2];
                str_text_id += "S:" + (Number(arr_order[0]) + 1) + " S_H:" + (Number(arr_order[1]) + 1) + " H:-1 H_P:-1 " + " R:" + (Number(arr_order[2]) + 1) + " ) ";
            } else {
                str_text_id += "S:" + (Number(arr_order[0]) + 1) + " S_H:" + (Number(arr_order[1]) + 1) + " H:" + (Number(arr_order[2]) + 1) + " H_P:" + (Number(arr_order[3]) + 1) + " R:" + (Number(arr_order[4]) + 1) + " ) ";
            }


            mc_get_top_fun("mc_update_load_txt", obj_lang_correct.MC_LANG_CORR_DEALING + str_text_id + obj_lang_correct.MC_LANG_CORR_ID_BOX + " ( " + (ui_idx + 1) + " / " + ui_cnt + " ) ", "mc_screen_loading_text");

            var str_val = mc_handle_screen_box_corr(obj_size, str_spot_final_data);


            mc_bright_color_correct("SET_PARAM", str_order, str_mode, str_val, obj_size.CHIP_NAME, str_type, function () {
                ui_idx += 1;
                mc_send();
                return;
            });
            return;
        }
        fun_callback();
        return;
    }
}
